#include <stdio.h>
#include <math.h>

typedef struct {
	float x;
	float y;
} Point;

typedef struct {
	Point *p;
	int n;
} Poly;

#define PI		M_PI
#define PI2		(PI * PI)
#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MAX(x,y)	((x) > (y) ? (x) : (y))

#define INSTALL(j) \
			xy[upfence].x = xy[j].x; \
			xy[upfence++].y = xy[j].y; \
			wedge.begin = -PI; \
			wedge.end = PI;

/*
 * An arc structure has a beginning angle and
 * an ending angle.  It should be in a canonical
 * form such that the beginning angle is
 * in [-PI,PI).  This implies that the end
 * angle is always greater than -PI, a fact
 * which is assumed in the routines below which
 * manipulate arcs.
 */
struct arc {
	double begin;
	double end;
};

/*
 * Given an ordered list of n points in the plane, and
 * a tolerance delta, find a subset of the points with
 * the same ordering such that the linear spline passing
 * through the new points passes within delta of each of
 * the original points.
 */
int
thin(po, delta)
Poly *po;
double delta;
{
	Point *xy = po->p;
	int n = po->n;
	int cur, next, upfence, downfence, m;
	double dist, theta, alpha, dx, dy;
	struct arc wedge;

	if(n <= 2 || delta <= 0)
		return;

	upfence = 0;
	INSTALL(0);
	for(cur = 0, next = 1; next < n; next++) {
		dx = xy[next].x - xy[cur].x;
		dy = xy[next].y - xy[cur].y;
		if(dx == 0 && dy == 0)
			continue;
		theta = atan2(dy, dx);
		if(!inarc(wedge, theta)) {
			cur = --next;
			INSTALL(cur);
			continue;
		}
		dist = hypot(dx, dy);
		if(dist > delta) {
			alpha = asin(delta / dist);
			intersect(&wedge, theta - alpha, theta + alpha);
		}
	}
	INSTALL(n-1);
	po->n = upfence;
}

/*
 * Test whether theta lies in the arc a.
 * Theta is expected to be in [-PI,PI).
 */
inarc(a, theta)
struct arc a;
double theta;
{
	if(a.begin <= theta && theta <= a.end)
		return(1);
	theta += PI2;
	if(a.begin <= theta && theta <= a.end)
		return(1);
	return(0);
}

/*
 * Intersect the arc a with the arc defined by begin
 * and end.  The arc is assumed to be in canonical form
 * but the arc defined by (begin,end) can be located
 * anywhere.
 */
intersect(a, begin, end)
struct arc *a;
double begin, end;
{
	/* move (begin,end) until it has a chance to intersect a */
	while(end < a->begin) {
		begin += PI2;
		end += PI2;
	}
	while(begin > a->end) {
		begin -= PI2;
		end -= PI2;
	}	

	/* if no intersection ... */
	if(end < a->begin || begin > a->end)
		a->begin = a->end = 0;

	/* do the intersection ... */
	else {
		a->begin = MAX(begin, a->begin);
		a->end = MIN(end, a->end);
	}

	/* canonicalize the intersection if necessary */
	while(a->begin >= PI) {
		a->begin -= PI;
		a->end -= PI;
	}
}

#define MAXCOORD	20000

main(ac, av)
char **av;
{
	double delta;
	int i, j, n, left, right;
	char buf[50];
	Point p[MAXCOORD];
	Poly po;

	if(ac != 2 || (delta = atof(av[1])) <= 0) {
		fprintf(stderr, "Usage: %s delta\n", av[0]);
		exit(1);
	}
	po.p = p;
	while(1) {
		if(scanf("%d%d\n", &left, &right) != 2)
			break;
		n = 0;
		while(1) {
			fgets(buf, 50, stdin);
			if(buf[0] == 'E')
				break;
			sscanf(buf, "%f%f", &p[n].x, &p[n].y);
			n++;
		}
		po.n = n;
		thin(&po, delta);
		printf("%d %d\n", left, right);
		for(j = 0; j < po.n; j++)
			printf(" %9.6f %9.6f\n", po.p[j].x, po.p[j].y);
		printf("EOR\n");
	}
	exit(0);
}
