# This shell script will extract part of a geographical database
# and use the data to create a new one.  The two input arguments
# are the names of the old and new databases.  The numbers of
# the regions to be extracted are read on the standard input.
# The result of running the script is three files: a .line file,
# a .gon file and a .N file.  The .line file must then be run
# through Lmake to make a binary .L file, and the .gon file must
# be run through Gmake to make a binary .G file.

case $# in
2) OLD=$1; NEW=$2;;
*) echo Usage: $0 old-name new-name; exit;;
esac

# create two files, gons and lines, giving a sorted list
# of the numbers of the polygons and polylines to be extracted
(tr -s ' \t' '\012' | sort -nu | tee gons | sed 's/^/gon /'; cat $OLD.gon) |
awk '
BEGIN {
	ngon = nline = 0
	gon = n = 1
}
$1 == "gon" {
	gnum[++ngon] = $2
}
$1 != "gon" {
	if($1 == "EOR") {
		if(gon == gnum[n])
			n++
		gon++
		continue
	}
	if(gon != gnum[n])
		continue
	for(i = 1; i <= NF; i++)
		lnum[++nline] = $i
}
END {
	for(i = 1; i <= nline; i++)
		print lnum[i]
}' | sed 's/-//' | sort -nu > lines

# extract the polygons
awk '
BEGIN {
	nline = 0
	while(getline <"lines" > 0)
		lmap[$0] = ++nline
	ngon = 0
	while(getline <"gons" > 0)
		gnum[++ngon] = $0
	gon = n = 1
}
{
	if($1 == "EOR") {
		if(gon == gnum[n]) {
			print "EOR"
			n++
		}
		gon++
		continue
	}
	if(gon != gnum[n])
		continue
	for(i = 1; i <= NF; i++)
		print ($i > 0 ? 1 : -1) * lmap[$i > 0 ? $i : -$i]
}' < $OLD.gon > $NEW.gon

# extract the polylines
awk '
BEGIN {
	nline = 0
	while(getline <"lines" > 0)
		lnum[++nline] = $0
	ngon = 0
	gmap[0] = 0
	while(getline <"gons" > 0)
		gmap[$0] = ++ngon
	line = n = 1
}
{
	if($1 == "EOR") {
		if(line == lnum[n]) {
			print "EOR"
			n++
		}
		line++
		continue
	}
	if(line != lnum[n])
		continue
	if($0 ~ "^ ") {
		print
		continue
	}
	left = gmap[$1] == "" ? 0 : gmap[$1]
	right = gmap[$2] == "" ? 0 : gmap[$2]
	print left, right
}' < $OLD.line > $NEW.line

# extract the names
awk -F'	' '
BEGIN {
	ngon = 0
	while(getline <"gons" > 0)
		gnum[++ngon] = $0
	gon = n = 1
}
{
	if(gon++ == gnum[n])
		print $1 "\t" n++
}' < $OLD.N > $NEW.N

rm gons lines
