Unit Solar;
{           Author:  Dr TS Kelso }
{ Original Version:  1990 Jul 29 }
{ Current Revision:  1992 Sep 30 }
{          Version:  1.20 }
{        Copyright:  1990-1992, All Rights Reserved }
{$N+}

INTERFACE
  Uses SGP_Math;

const
  eclipsed : boolean = false;
  show_vis : boolean = false;

var
  civil,
  nautical,
  astronomical : double;  {Twilight elevations}
  solar_pos    : vector;

Procedure Calculate_Solar_Position(time : double;
                       var solar_vector : vector);
Function Depth_of_Eclipse(time : double;
                            r1 : vector) : double;

IMPLEMENTATION
  Uses SGP_Intf,SGP_Time;

const
  sr = 696000.0;       {Solar radius - kilometers (IAU 76)}
  AU = 1.49597870E8;   {Astronomical unit - kilometers (IAU 76)}

Procedure Calculate_Solar_Position(time : double;
                       var solar_vector : vector);
  var
    mjd,year,T,M,L,e,C,O,Lsa,nu,R,eps : double;
    ob                                : vector;
  begin
  mjd := time - 2415020.0;
  year := 1900 + mjd/365.25;
  T := (mjd + Delta_ET(year)/secday)/36525.0;
  M := Radians(Modulus(358.47583 + Modulus(35999.04975*T,360.0)
     - (0.000150 + 0.0000033*T)*Sqr(T),360.0));
  L := Radians(Modulus(279.69668 + Modulus(36000.76892*T,360.0)
     + 0.0003025*Sqr(T),360.0));
  e := 0.01675104 - (0.0000418 + 0.000000126*T)*T;
  C := Radians((1.919460 - (0.004789 + 0.000014*T)*T)*Sin(M)
     + (0.020094 - 0.000100*T)*Sin(2*M) + 0.000293*Sin(3*M));
  O := Radians(Modulus(259.18 - 1934.142*T,360.0));
  Lsa := Modulus(L + C - Radians(0.00569 - 0.00479*Sin(O)),twopi);
  nu := Modulus(M + C,twopi);
  R := 1.0000002*(1 - Sqr(e))/(1 + e*Cos(nu));
  eps := Radians(23.452294 - (0.0130125 + (0.00000164 - 0.000000503*T)*T)*T
       + 0.00256*Cos(O));
  R := AU*R;
  solar_vector[1] := R*Cos(Lsa);
  solar_vector[2] := R*Sin(Lsa)*Cos(eps);
  solar_vector[3] := R*Sin(Lsa)*Sin(eps);
  solar_vector[4] := R;
  end; {Procedure Calculate_Solar_Position}

Function Depth_of_Eclipse(time : double;
                            r1 : vector) : double;
  var
    r1_r1,r1_r2,r2_r2,k,d,ds : double;
    r2                       : vector;
  begin
  Magnitude(r1);
  Calculate_Solar_Position(time,r2);
  solar_pos := r2;
  r1_r1 := Sqr(r1[4]);
  r1_r2 := -Dot(r1,r2);
  r2_r2 := Sqr(r2[4]);
  k := r1_r2/r2_r2;
{Calculate perpendicular distance from anti-solar vector}
  d := Sqrt(r1_r1 - Sqr(r1_r2)/r2_r2);
{Calculate shadow distance ds}
  ds := xkmper + k * (sr - xkmper);
{If d < ds, then satellite is in eclipse}
  if (k > 0) and (d < ds) then
    eclipsed := true
  else
    eclipsed := false;
  Depth_of_Eclipse := d - ds
  end; {Function Depth_of_Eclipse}

  begin
  civil        := Radians(-6);
  nautical     := Radians(-12);
  astronomical := Radians(-18);

end.
