Unit SGP_Math;
{           Author:  Dr TS Kelso }
{ Original Version:  1991 Oct 30 }
{ Current Revision:  1992 Sep 28 }
{          Version:  1.30 }
{        Copyright:  1991-1992, All Rights Reserved }
{$N+}

INTERFACE

type
  vector = array [1..4] of double;

const
  twopi = 2 * pi;
  zero : vector = (0,0,0,0);

Function Sign(arg : double) : shortint;
Function Cube(arg : double) : double;
Function Power(arg,pwr : double) : double;
Function Radians(arg : double) : double;
Function Degrees(arg : double) : double;
Function Tan(arg : double) : double;
Function ArcSin(arg : double) : double;
Function ArcCos(arg : double) : double;
Function Modulus(arg1,arg2 : double) : double;
Function Fmod2p(arg : double) : double;
Function AcTan(sinx,cosx : double) : double;
Function Dot(v1,v2 : vector) : double;
Procedure Magnitude(var v : vector);
Procedure Cross(v1,v2 : vector; var v3 : vector);

IMPLEMENTATION

Function Sign(arg : double) : shortint;
  begin
  if arg > 0 then
    Sign := 1
  else if arg < 0 then
    Sign := -1
  else
    Sign := 0;
  end; {Function Sign}

Function Cube(arg : double) : double;
  begin
  Cube := arg*Sqr(arg);
  end; {Function Cube}

Function Power(arg,pwr : double) : double;
  begin
  if arg > 0 then
    Power := Exp(pwr*Ln(arg))
  else
    Writeln(output,'Invalid argument in Function Power!');
  end; {Function Power}

Function Radians(arg : double) : double;
  begin
  Radians := arg*pi/180;
  end; {Function Radians}

Function Degrees(arg : double) : double;
  begin
  Degrees := arg*180/pi;
  end; {Function Degrees}

Function Tan(arg : double) : double;
  begin
  Tan := Sin(arg)/Cos(arg);
  end; {Function Tan}

Function ArcSin(arg : double) : double;
  begin
  ArcSin := ArcTan(arg/Sqrt(1-Sqr(arg)));
  end; {Function ArcSin}

Function ArcCos(arg : double) : double;
  begin
  ArcCos := pi/2 - ArcSin(arg);
  end; {Function ArcCos}

Function Modulus(arg1,arg2 : double) : double;
  var
    modu : double;
  begin
  modu := arg1 - Trunc(arg1/arg2) * arg2;
  if modu >= 0 then
    Modulus := modu
  else
    Modulus := modu + arg2;
  end; {Function Modulus}

Function Fmod2p(arg : double) : double;
  begin
  Fmod2p := Modulus(arg,twopi);
  end; {Function Fmod2p}

Function AcTan(sinx,cosx : double) : double;
  begin
  if cosx = 0 then
    if sinx > 0 then
      Actan := pi/2
    else
      Actan := 3*pi/2
  else if cosx > 0 then
    Actan := ArcTan(sinx/cosx)
  else
    Actan := pi + ArcTan(sinx/cosx);
  end; {Function Actan}

Function Dot(v1,v2 : vector) : double;
  begin
  Dot := v1[1]*v2[1] + v1[2]*v2[2] + v1[3]*v2[3];
  end;  {Function Dot}

Procedure Magnitude(var v : vector);
  begin
  v[4] := Sqrt(Sqr(v[1]) + Sqr(v[2]) + Sqr(v[3]));
  end; {Procedure Magnitude}

Procedure Cross(v1,v2 : vector; var v3 : vector);
  begin
  v3[1] := v1[2]*v2[3] - v1[3]*v2[2];
  v3[2] := v1[3]*v2[1] - v1[1]*v2[3];
  v3[3] := v1[1]*v2[2] - v1[2]*v2[1];
  end; {Procedure Cross}

end.
