Unit SGP_Init;
{           Author:  Dr TS Kelso }
{ Original Version:  1992 Sep 01 }
{ Current Revision:  1992 Sep 13 }
{          Version:  1.10 }
{        Copyright:  1992, All Rights Reserved }
{$N+}

INTERFACE

const
  max_sats = 250;

type
  line_data = string[69];
  two_line  = array [1..2] of line_data;

var
  visible              : boolean;
  epoch                : double;
  catnr,elset          : string;
  obs_name             : string[25];
  selected             : array [1..max_sats] of boolean;
  sat_name             : array [1..max_sats] of string[22];
  sat_data             : array [1..max_sats] of two_line;
  data_drive,data_dir,
  work_drive,work_dir  : string;

Procedure Program_Initialize(program_name : string);
Procedure Program_End;

IMPLEMENTATION
  Uses CRT,Support;

Procedure Program_Initialize(program_name : string);
  var
    space,lines : byte;
    line,fn     : string;
    fi          : text;
  begin
{ Input header file describing program, 22 lines by 79 columns maximum }
  ClrScr;
  fn := program_name + '.HDR';
  if File_Exists(fn) then
    begin
    Assign(fi,fn);
    Reset(fi);
    lines := 0;
    repeat
      lines := lines + 1;
      Readln(fi,line);
      Writeln(line);
    until EOF(fi) or (lines = 22);
    Close(fi);
    end; {if}
{ Input directory configuration file }
  fn := program_name + '.CFG';
  if File_Exists(fn) then
    begin
    Assign(fi,fn);
    Reset(fi);
    Readln(fi,data_drive);
    if data_drive <> '' then
      begin
      data_drive[1] := UpCase(data_drive[1]);
      if data_drive[1] in ['A'..'Z'] then
        data_drive := data_drive[1] + ':'
      else
        data_drive := '';
      end; {if}
    Readln(fi,data_dir);
    if data_dir <> '' then
      begin
      space := Pos(' ',data_dir);
      if space > 0 then
        data_dir := Copy(data_dir,1,space-1);
      if data_dir[Length(data_dir)] <> '\' then
        data_dir := data_dir + '\';
      end; {if}
    Readln(fi,work_drive);
    if work_drive <> '' then
      begin
      work_drive[1] := UpCase(work_drive[1]);
      if work_drive[1] in ['A'..'Z'] then
        work_drive := work_drive[1] + ':'
      else
        work_drive := '';
      end; {if}
    Readln(fi,work_dir);
    if work_dir <> '' then
      begin
      space := Pos(' ',work_dir);
      if space > 0 then
        work_dir := Copy(work_dir,1,space-1);
      if work_dir[Length(work_dir)] <> '\' then
        work_dir := work_dir + '\';
      end; {if}
    Close(fi);
    end {if}
  else
    begin
    data_drive := '';
    data_dir   := '';
    work_drive := '';
    work_dir   := '';
    end; {else}
  end; {Procedure Initialize}

Procedure Program_End;
  begin
  GotoXY(1,24);
  Cursor_On;
  end; {Procedure Program_End}

end.
