Program TrakStar2;
{           Author:  Dr TS Kelso }
{ Original Version:  1992 Jun 29 }
{ Current Revision:  1992 Oct 01 }
{ Modified for Y2K:  1999 Mar 07 }
{          Version:  2.15a }
{        Copyright:  1992-1999, All Rights Reserved }
{$N+,E+}
  Uses CRT,Support,
       SGP_Init,SGP_In,
       SGP_Time,SGP_Math,
       SGP_Conv,Solar,
       SGP4SDP4,SGP_Obs,
       SGP_Out;

const
  menu : options = ('Output Type',
                    'ECI Position/Velocity',
                    'Latitude/Longitude/Altitude',
                    'Look Angles',
                    'Right Ascension/Declination','Exit','','','','','');
  pass_menu : options = ('Pass Type',
                         'Visible Passes',
                         'All Passes','','','','','','','','');
  twi_menu : options = ('Twilight Type',
                        'Civil',
                        'Nautical',
                        'Astronomical','','','','','','','');

var
  first_pass,dark     : boolean;
  nr_sats,cx          : integer;
  option,twi_option   : integer;
  i,j                 : longint;
  DoE,twilight        : double;
  jtime1,jtime2,jt,dt : double;
  fn1,fn2,prefix      : string;
  time1,time2,dtime   : time_set;
  sat_pos,sat_vel,
  obs_pos,obs_vel,
  obs_gd,sat_gd,
  obs,obs_solar       : vector;

Procedure Initialize;
  begin
  cx := 40;
  TextBackground(black);
  TextColor(lightgray);
  D_M_S := false;
  N_E_W_S := false;
  time_res:=1;
  angle_res:=8;
  dist_res:=4;
  end; {Procedure Initialize}

BEGIN

  if (ParamCount <> 1) then
  	begin
   writeln('Usage: ORBIT <output-file-name>');
   Exit;
   end;

  Initialize;
  Program_Initialize('TRAKSTAR');

  {Show_Status_Line('Select output data type');
  Show_Instructions('<'+UpDown+' to select, ENTER when done>');
  option := Select_Option(menu,4,cx-18,1,34,4);}
  option := 2; {Always choose LLA}

  if option in [3,4] then
    begin
    Show_Status_Line('Select pass conditions');
    Show_Instructions('<'+UpDown+' to select, ENTER when done>');
    show_vis := (Select_Option(pass_menu,2,cx+22,1,14,2) = 1);
    if show_vis then
      begin
      Show_Status_Line('Select twilight conditions');
      Show_Instructions('<'+UpDown+' to select, ENTER when done>');
      twi_option := Select_Option(twi_menu,3,cx+22,5,14,3);
      case twi_option of
        1 : twilight := civil;
        2 : twilight := nautical;
        3 : twilight := astronomical;
        end; {case}
      end; {if}
    end {if}
  else
    show_vis := true;

  Show_Status_Line('Select file of two-line element sets');
  Show_Instructions('<'+UpDown+' to select, ENTER when done>');
  fn1 := Select_File('Satellite File',data_drive+data_dir+'*.TLE','USER.TLE',cx-18,7,14,5);
  nr_sats := Input_Satellite_Data(fn1);
  Show_Status_Line('Satellites for output');
  Show_Instructions('<'+UpDown+', SPACE to toggle (A toggle all), ENTER when done>');
  Select_Satellites('Select Satellites',cx+2,14,34,8,nr_sats);
  ClearWindow(cx+2,14,34,8);

  if option in [3,4] then
    begin
    Show_Status_Line('Select file of observation sites');
    Show_Instructions('<'+UpDown+' to select, ENTER when done>');
    fn2 := Select_File('Observer File',data_drive+data_dir+'*.OBS','',cx+2,7,14,5);
    end; {if}
  Clear_Status_Line;

  Get_Current_Time(time1);
  Show_Status_Line('Specify start/stop times');
  Show_Instructions('<'+cursors+'/Home/End to select, ENTER when done>');
  Select_Time('Start Time',cx+2,14,time1,5);
  time2 := time1;
  Select_Time('Stop Time',cx+2,17,time2,5);
  Zero_Time(dtime);
  dtime.hu := 50;
  {Show_Status_Line('Specify output time interval');
  Show_Instructions('<'+cursors+'/Home/End to select, ENTER when done>');
  Select_Time_Interval('Time Interval',cx+2,20,dtime,6);}
  Clear_Status_Line;

  with time1 do
    jtime1 := Julian_Date_of_Year(yr) + DOY(yr,mo,dy)
            + Fraction_of_Day(hr,mi,se,hu);
  with time2 do
    jtime2 := Julian_Date_of_Year(yr) + DOY(yr,mo,dy)
            + Fraction_of_Day(hr,mi,se,hu);
  with dtime do
    dt := dy + Fraction_of_Day(hr,mi,se,hu);

  if option in [1,2] then
    begin
    for i := 1 to nr_sats do
      if selected[i] then
        begin
        j := 0;
        Convert_Satellite_Data(i);
        case option of
          1 : prefix := 'ECI';
          2 : prefix := 'LLA';
          end; {case}
        Assign(fout,{work_drive + work_dir + prefix + catnr + '.' + elset}ParamStr(1));
        Rewrite(fout);
        GotoXY(1,12);
        Show_Status_Line(sat_name[i] + ' ');
        repeat
          Mark_Time;
          jt := jtime1 + j*dt;
          SGP(jt,sat_pos,sat_vel);
          Convert_Sat_State(sat_pos,sat_vel);
          if show_vis then
            DoE := Depth_of_Eclipse(jt,sat_pos);
          case option of
            1 : Output_ECI(jt,sat_pos,sat_vel);  {ECI}
            2 : begin
                Calculate_LatLonAlt(sat_pos,jt,sat_gd);
                Output_LatLonAlt(jt,sat_gd);
                end; {LLA}
            end; {case}
          j := j + 1;
        until jt >= jtime2;
        Close(fout);
        end; {if}
    end {if}
  else
    begin
    Assign(fobs,data_drive + data_dir + fn2);
    Reset(fobs);
    first_pass := true;
    repeat
      Input_Observer(obs_gd);
      for i := 1 to nr_sats do
        if selected[i] then
          begin
          j := 0;
          Convert_Satellite_Data(i);
          Show_Status_Line(obs_name + ' / ' + sat_name[i] + ' ');
          if show_vis then
            case option of
              3 : prefix := 'VOB';
              4 : prefix := 'VRD';
              end {case}
          else
            case option of
              3 : prefix := 'OBS';
              4 : prefix := 'RAD';
              end; {case}
          Assign(fout,work_drive + work_dir + prefix + catnr + '.' + elset);
          if first_pass then
            Rewrite(fout)
          else
            Append(fout);
          repeat
            Mark_Time;
            jt := jtime1 + j*dt;
            SGP(jt,sat_pos,sat_vel);
            Convert_Sat_State(sat_pos,sat_vel);
            if show_vis then
              begin
              DoE := Depth_of_Eclipse(jt,sat_pos);
              Calculate_Obs(solar_pos,zero,obs_gd,jt,obs_solar);
              dark := (obs_solar[2] < twilight);
              end; {if}
            case option of
              3 : begin
                  Calculate_Obs(sat_pos,sat_vel,obs_gd,jt,obs);
                  if visible and show_vis then
                    visible := visible and (not eclipsed) and dark;
                  Output_Obs(jt,obs);
                  end; {Look angles}
              4 : begin
                  Calculate_RADec(sat_pos,sat_vel,obs_gd,jt,obs);
                  if visible and show_vis then
                    visible := visible and (not eclipsed) and dark;
                  Output_RADec(jt,obs);
                  end; {Right ascension/declination}
              end; {case}
            j := j + 1;
          until jt >= jtime2;
          if visible then
            Writeln(fout);
          Close(fout);
          end; {if}
        first_pass := false;
    until EOF(fobs);
    Close(fobs);
    end; {else}

  Clear_Status_Line;
  Program_End;

END.
