#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>

int map_width;
int map_height;

double south, north, west, east;

const double M_PI = 3.14159265358979323846;

// -----------------------------------------------------------------------

void save_bitmap(unsigned char *info, int line_length, int num_of_lines, const char *file_name)
{
    int handle = 0;
    int i;

    BITMAPFILEHEADER file_header = {
        0x4D42,
        sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER)+256*sizeof(RGBQUAD) + num_of_lines * line_length,
        0,
        0,
        sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER)+256*sizeof(RGBQUAD)
    };
    BITMAPINFOHEADER info_header = {
        sizeof(BITMAPINFOHEADER),       // size
        line_length,                    // width
        num_of_lines,                   // height
        1,                              // planes = 1
        8,                              // bpp
        BI_RGB,                         // compression
        0,                              // size, may be 0
        100,                            // hor resolution
        100,                            // ver resolution
        0,                              // colors used in color table,
        0                               // important colors
    };

    handle = open(file_name, O_RDWR|O_CREAT|O_TRUNC|O_BINARY,S_IREAD|S_IWRITE);
    if (handle == -1) {
        printf("Error opening output file\n");
        exit(-1);
    }

    write(handle, &file_header, sizeof(BITMAPFILEHEADER));
    write(handle, &info_header, sizeof(BITMAPINFOHEADER));
    for (i=0; i<256; i++) {
        // use a greyscale palette
        RGBQUAD quad = {i,i,i,0};
        write(handle, &quad, sizeof(RGBQUAD));
    }

    write(handle, info, line_length * num_of_lines);

    close(handle);
}

// -----------------------------------------------------------------------
// functions for reading the world file
// taken from the original UNSQUASH.C file
// -----------------------------------------------------------------------

FILE *hnd;

int get3()
{
	int c, d, e;

    c = fgetc(hnd) & 0xff;
    d = fgetc(hnd) & 0xff;
    e = fgetc(hnd) & 0xff;
	return((c<<16)+(d<<8)+e-8388608);
}

int get2()
{
	int c, d;

    c = fgetc(hnd) & 0xff;
    d = fgetc(hnd) & 0xff;
	return((c || d) ? (c<<8)+d-32768 : get3());
}

int get()
{
	int c;
    if((c = fgetc(hnd)) < 0)
		return(0);
	c &= 0xff;
	return(c ? c-128 : get2());
}

static int last_x;
static int last_y;

void line(unsigned char *picture, int x1, int y1, int x2, int y2)
{
    // Assumes y2>=y1
    double dx, dy;
    double cur_x, cur_y;
    int stages = 0;
	int i;

    if (y2 < y1) {
        printf("ASSERT FAIL line\n");
        exit(-1);
    }

    if (x2 > x1) {
        if ((x2 - x1) > (y2 - y1)) {
            stages = x2 - x1 + 1;
            dx = 1;
            dy = (double)(y2 - y1 + 1) / stages;
        } else {
            stages = y2 - y1 + 1;
            dx = (double)(x2 - x1 + 1) / stages;
            dy = 1;
        }
    } else {                            // x1 >= x2
        if ((x1 - x2) > (y2 - y1)) {
            stages = x1 - x2 + 1;
            dx = -1;
            dy = (double)(y2 - y1 + 1) / stages;
        } else {
            stages = y2 - y1 + 1;
            dx = (double)(x2 - x1 + 1) / stages;
            dy = 1;
        }
    }

    cur_x = (double)x1;
    cur_y = (double)y1;
    for(i=0; i<stages; i++) {
        int final_y = (int)floor(cur_y);
        int final_x = (int)floor(cur_x);
        if ((final_y >= 0) && (final_y < map_height) && (final_x >=0) && (final_x < map_width)){
            picture[final_y*map_width + final_x] = 0;
        }
        cur_x += dx;
        cur_y += dy;
    }
}

void moveto(int x, int y)
{
    last_x = x;
    last_y = y;
}

void lineto(unsigned char *picture, int x, int y)
{
    if (y>last_y) {
        line(picture, last_x, last_y, x, y);
    } else {
        line(picture, x, y, last_x, last_y);
    }

    last_x = x;
    last_y = y;
}

void draw_map(const char *input_file)
{
    unsigned char *picture;
        int n, i, x, y, l, r;
    double latitude;
    double longitude;

    picture = (unsigned char*)malloc(map_width * map_height);
    memset(picture, 255, map_width * map_height);
    
    hnd = fopen(input_file, "rb");
    if (hnd == NULL) {
        printf("Cannot open input file\n");
        return;
    }

    while ((n = get()) > 0) {
		l = get(); r = get();
		printf("%d %d\n", l, r);
		x = get(); y = get();
        latitude = y/1e6;
        longitude = x/1e6;
        moveto((int)floor((double)map_width*(longitude-west)/(east-west)),(int)floor((double)map_height*(latitude-south)/(north-south)));
		for(i = 1; i < n; i++) {
			x += get(); y += get();
            latitude = y/1e6;
            longitude = x/1e6;
            if ((longitude > west - 0.1) && (longitude < east + 0.1)) {
                lineto(picture, (int)floor((double)map_width*(longitude-west)/(east-west)),(int)floor((double)map_height*(latitude-south)/(north-south)));
            }
		}
		printf("EOR\n");
	}
    fclose(hnd);

    save_bitmap(picture, map_width, map_height, "map.bmp");
}

void write_config()
{
    FILE *out_file;

    out_file = fopen("map.cfg", "w");

    fprintf(out_file, "%lf %lf %lf %lf\n", west, east, south, north);

    fclose(out_file);
}

int main(int argc, char *argv[])
{
    if (argc < 8) {
        printf("Usage:\n");
        printf("\tMAP <small-lin> <width> <height> <west> <east> <south> <north>\n");
        printf("Small-lin is the input map file name, originally the SMALL.LIB file\n");
        printf("Width and height are in pixels\n");
        printf("West in negative, east positive, south negative, north positive, all in degrees\n");
        return 0;
    }

    map_width = atoi(argv[2]);
    map_height = atoi(argv[3]);

    west = atof(argv[4])/180*M_PI;
    east = atof(argv[5])/180*M_PI;
    south = atof(argv[6])/180*M_PI;
    north = atof(argv[7])/180*M_PI;

    write_config();

    draw_map(argv[1]);
}
